This ZIP file contains 3 folders of PDF files, where each folder has PDF files with the same filename but use different PDF settings: 

- [OwnerPwdOnly](./OwnerPwdOnly/) - PDFs only have an Owner Password (see [password.txt](./OwnerPwdOnly/password.txt))
- [UserPwd=OwnerPwd](./UserPwd=OwnerPwd/) - PDFs have both a User and Owner Password that are the same (see [password.txt](./UserPwd=OwnerPwd/password.txt))
- [PublicKey](./PublicKey/) - PDFs use a Public Key (the [demo CA certificate](./PublicKey/demo-ca.cert.pem) and [keys for public-key security handler](./PublicKey/recipient.p12) that was used are provided. The password is in [password.txt](./PublicKey/password.txt))

Each PDF filename is constructed in a logical order:

   `<AES Algorithm>-standard-<MAC and signature settings>-<XMP Metadata settings>.pdf`

1. AES algorithm:
   - `aes-cbc-256`: uses 256 bit AES-CBC as per ISO 32000-2
   - `aes-gcm-256`: uses 256 bit AES-GCM as per ISO/TS 32003 **DRAFT TS!**

1. MAC and signature settings as per ISO/TS 32004 **DRAFT TS!**:
   -  `no-mac`: No MAC
   - `std-mac`: standalone MAC
   - `sign+mac`: Sign + MAC
   - `timestamp+mac`: Timestamp signature + MAC
   - `sign-PAdES-B-LT`: signed as PAdES-B-LT + MAC
   - `sign-PAdES-B-LTA`: signed as PAdES-B-LTA + MAC

1. XMP Metadata setting:
   - _\<nothing>_: document XMP metadata is unencrypted
   - `-encrypted-metadata`: document XMP metadata is encrypted

**Because both ISO/TS 32003 and ISO/TS 32004 are currently not yet finalized and published by ISO TC 171 SC 2 WG 8, technical details may change and result in making these sample PDFs invalid. Use at your own risk! Samples provided in good faith and should not be redistributed.**
